<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="movieNum" select="'default'"/>
<xsl:param name="aveRating" select="'2.5'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="productPage" select="'default'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="addMyListParam" select="'default'"/>
<xsl:param name="predRatingParam" select="'default'"/>
<xsl:param name="predRating" select="'defualt'"/>
	

<xsl:template name="productURL">
	<xsl:value-of select="$productPage"/>?<xsl:value-of select="$itemIDParam"/>=<xsl:value-of select="$itemID"/>&amp;<xsl:value-of select="$predRatingParam"/>=<xsl:value-of select="$predRating"/>
</xsl:template>

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<!-- Template for the movie: outputs a checkbox for adding the movie
	to the user's MyList, and the title of the movie which links to the
	product page.
-->
<xsl:template match="/MOVIE">
	<xsl:param name="prodURL">
		<xsl:call-template name="productURL"/>
	</xsl:param>
	<table border="0" cellspacing="0" cellpadding="0" width="291">
	<tr> 
		<td width="291" valign="top"> 
			<table width="89" border="0" cellspacing="0" cellpadding="0">
			<tr id="greenback"> 
				<td id="smalltext">&#160;add to my list 
					<input type="checkbox">
						<xsl:attribute name="name"><xsl:value-of select="$addMyListParam"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$itemID"/></xsl:attribute>
					</input>
				</td>
			</tr>
			</table>
			<a id="movieLink"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
				<b>	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) <xsl:value-of select="RELEASES/RELEASES_ITEM/RATINGTEXT"/>	</b>
			</a>
		</td>
	</tr>
	</table>

			  
   
</xsl:template>

</xsl:stylesheet>


